//: ![Logo](logo.png)
import UIKit
import PlaygroundSupport
//: ## Animation mit UIView.animate()
//:Um einen interaktiven Playground zu erstellen, haben wir eine Klasse DemoView erstellt und in eine separate Datei (Sources/DemoView.swift) ausgelagert. Sie definiert eine UIView als Hintergrund und platziert einen Button in der linken oberen Ecke, der über die public Property demoButton erreichbar ist.
//Demo-View erstellen
let container = demoView(frame: CGRect(x: 0, y: 0,
                                       width: 400, height: 600))
//Button in die Mitte schieben
let frame = container.frame
container.demoButton.center = CGPoint(x:frame.midX,
                                      y: frame.midY)
//Live-Preview aktivieren
PlaygroundPage.current.liveView = container
//: Die View ist nun permanent im Assistantview sichtbar, sofern Sie diesen in Xcode oben rechts über den Button mit zwei Kreisen aktiviert haben oder am iPad auf den "Meinen Code ausführen"-Button unten rechts getippt haben. Falls nicht, klicken Sie bitte jetzt auf einen dieser Buttons. :) 
//: Um die Animation kontrolliert starten zu können, lassen wir sie erst auf Knopfdruck loslaufen. Da Sie den Playground nicht via "self" als Target adressieren können, verpacken Sie die Animationsroutine in einem eigenen Objekt
public class actionHandler: NSObject {
    public func animate() {

        UIView.animate(withDuration: 2.0){
            container.demoButton.center.x = frame.maxX
        }
        UIView.animate(withDuration: 2.0, delay: 2.0, options: [UIViewAnimationOptions.curveEaseIn], animations:{
            container.demoButton.center.x = frame.midX
        },completion: { _ in
            container.demoButton.setTitle("finished",
                                          for: .normal)
        })
    }
}
//: Anschließend können Sie die Action wie gewohnt an den Button anhängen
let responder = actionHandler()
container.demoButton.addTarget(responder,
                               action: #selector(actionHandler.animate),
                               for: .touchDown)
//: [Nächste Seite](@next)
